/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.modifiers.EnergyBaseModifier;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.recipe.tinkerstation.ValidatedResult;
import slimeknights.tconstruct.library.tools.context.ToolRebuildContext;
import slimeknights.tconstruct.library.tools.nbt.IModDataView;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModDataNBT;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class EnergyStorageModifier
extends Modifier {
    public ValidatedResult validate(IToolStackView tool, int level) {
        int max = tool.getVolatileData().getInt(EnergyBaseModifier.MAX_ENERGY);
        if (tool.getPersistentData().getInt(EnergyBaseModifier.STORED_ENERGY) > max) {
            tool.getPersistentData().putInt(EnergyBaseModifier.STORED_ENERGY, max);
        }
        return ValidatedResult.PASS;
    }

    public void onRemoved(IToolStackView tool) {
        if (tool.getVolatileData().getInt(EnergyBaseModifier.MAX_ENERGY) == 0) {
            tool.getPersistentData().remove(EnergyBaseModifier.STORED_ENERGY);
        }
    }

    public void addVolatileData(ToolRebuildContext context, int level, ModDataNBT volatileData) {
        if (volatileData.contains(EnergyBaseModifier.MAX_ENERGY, 3)) {
            volatileData.putInt(EnergyBaseModifier.MAX_ENERGY, volatileData.getInt(EnergyBaseModifier.MAX_ENERGY) + this.getCapacity() * level);
        } else {
            volatileData.putInt(EnergyBaseModifier.MAX_ENERGY, this.getCapacity() * level);
        }
        if (!volatileData.contains(EnergyBaseModifier.ENERGY_OWNER, 8)) {
            volatileData.putString(EnergyBaseModifier.ENERGY_OWNER, this.getId().toString());
        }
    }

    public void addInformation(IToolStackView tool, int level, Player player, List<Component> tooltip, TooltipKey key, TooltipFlag flag) {
        if (tool instanceof ToolStack && this.isOwner(tool.getVolatileData())) {
            tooltip.add((Component)new TranslatableComponent("tooltip.tinkerscalibration.stored_enegry", new Object[]{tool.getPersistentData().getInt(EnergyBaseModifier.STORED_ENERGY), tool.getVolatileData().getInt(EnergyBaseModifier.MAX_ENERGY)}).m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)this.getColor()))));
        }
    }

    public int getCapacity() {
        return 50000;
    }

    public boolean isOwner(IModDataView volatileData) {
        return this.getId().toString().equals(volatileData.getString(EnergyBaseModifier.ENERGY_OWNER));
    }
}

